.H 1 "User Types Window"
The User Types window displays the declarations of structs and unions. 
For each type of struct or union defined in a program,
pi maintains a template
that describes how an instance of that type is displayed.
The template consists of:
.AL 1
.LI
A list of members that should be displayed.
.LI
The formatting options that should be used to display each member.
.LE
.P
In addition to the type's declaration,
the User Types window displays the current template settings.
From the menus, you may add and remove members from
the template's list of members to display and for each member,
you may set the formatting options.
The window does not accept keyboard input.
.P
In many debugging sessions, the User Types window is never opened.
Members of structs and unions may be added implicitly to a template's
display list by asking to display that member in a Frame window.
Similarly, setting the formatting options for a structure or union member
in a Frame window automatically changes them in the template.
However, only the User Types window may be used to
remove members from the display list of a struct or union's template.
.H 2 "User Types Layout"
The title bar identifies the window type and displays the process id 
number or name of the core file.
The lines within the window display the declarations for structs and unions.
Lines displaying members are in the format:
.DS I N
[>>>]	type	member_name;	format_options
.DE
.P
The optional ">>>" characters at the beginning of a line, if present,
indicate the member is in the template's list of displayed members.
By default, the initial list contains the first two members in the
structure declaration.
The type field displays the data type of that member.
.P
The format_options field displays the current formatting options.
If the member is another struct or union,
the format_options field is empty, and the format used to display it
is inherited from the template for that type.
.P
Examining a struct and union type for the first time in a Frame
window displays that type in the User Types window automatically, if it is open.
Also, asking to see or changing the format of a struct or
union member from a Frame window automatically updates that
member's line in the User Types window.
.H 2 "User Types Menu Bar"
The "structs" menu contains an entry listing the tag name for every
struct or union type defined in the program's symbol table.
Selecting an entry displays the declaration for that type
and selects the first line in the declaration.
.H 2 "User Types Line Menus"
If the line displays a member of a struct or union that is
not another struct or union, the line menu contains the following
entries:
.VL 9 1
.LI "show"
Add the member to the struct or union's list of members to display.
This entry is only available on lines that do not start with ">>>".
.LI "hide"
Remove the member from the struct or union's list of members to display.
This entry is only available on lines that start with ">>>".
.LI "format"
This menu allows you to change the formatting options used to display
the member.
The menu depends on the members type, as described in "Format Menus".
Selecting an entry in the format menu of a member that is not in the
display list automatically adds it to the list.
.LE
.P
If the member on a line is a struct or union,
the "format" entry is replaced with an entry of the form:
.VL 9 1
.LI "struct|union tag_name"
.br 
Choosing these entries displays the declaration for that structure
in the window and then selects the first line of the 
structure's declaration.
This way, structures that have other structures embedded in them
can be browsed through easily.
.LE
.P
The first and last line of a struct or union's declaration in the
window, i.e. lines of the form:
.DS I N
struct|union tag_name {
} struct|union tag_name
.DE
.P
generate menus that allow all the members to be added to or
removed from the template's display list with a single menu selection:
.VL 10 1
.LI "show all"
Add all members of the struct or union to the template's display list.
This is equivalent to selecting "show" for each member.
.LI "hide all"
Remove all members of the struct or union from the template's display list.
This is equivalent to selecting "hide" for each member. 
.LE
